/**
* Script: loadstate.js
* Written by: Radnen
* Updated: 12/18/2010
**/

function LoadState(name)
{
	if (!name) name = "LoadState";
	this.inherit = State;
	this.inherit(name);
	
	var list = GetFileList();
	var files = [];
	var file = null;
	
	for (var i = 0; i < list.length; ++i) {
		files[i] = list[i].substr(0, list[i].length-4);
	}
		
	this.x = SW/2-250;
	this.y = SH/2-166;
	
	var c_holder = new ControlHolder(0, 0, SW, SH);
	var panel = new Panel(c_holder, this.x, this.y, SW, SH);
	
	var questitems = new ListBox(panel, 20, 36, 260, 220);
	for (var i = 0; i < files.length; ++i) {
		questitems.addText(files[i], function() {
			loaditem.enabled = true;
			file = files[Utility.indexOf(files, questitems.item.text)];
		});
	}
	
	var loaditem = new EasyButton("Load", this.x+335, this.y+280);
	loaditem.enabled = false;
	loaditem.onClick.add(function(sender) {
		Audio.playSound(System.clickSnd);
		StateManager.states = [];
		NewGame(file);
	}, this);
	var backitem = new EasyButton("Back", this.x+100, this.y+280);
	backitem.onClick.add(function(sender) {
		Audio.playSound(System.cancelSnd);
		sender.hide();
	}, this);	
	
	this.render.add(function() {
		Resources.images.questmenu.blit(this.x, this.y);
		if (file != null) {
			Rectangle(this.x+290, this.y+12, 200, 230, Colors.clearBlack);
			System.textFont.drawText(this.x+290, this.y+12, file);
		}
		c_holder.draw();
		Rectangle(this.x+24, this.y+16, 260, 20, Colors.clearBlack);
		System.textFont.drawText(this.x+24, this.y+16, "Saved Games:");
		if (files.length == 0)
			System.textFont.drawText(this.x+24, this.y+36, "[No Files Here]");
		loaditem.draw();
		backitem.draw();
	});
	
	this.update.add(function() {
		c_holder.update();
		loaditem.update();
		backitem.update();
	});
	
	c_holder.controls.push(panel);
	c_holder.focusedControl = panel;
	panel.controls.push(questitems);
}